<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class EnableSeniorityAnniversary extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->changeFieldFormOptions('users', 'birthday', false, 'group_advanced_options');
        Artisan::call('models:rebuild');

        Artisan::call('db:seed', [
            '--class' => 'Inside\\Content\\Seeders\\SeniorityAnniversarySeeder',
        ]);

        Artisan::call('db:seed', [
            '--class' => 'Inside\\Notify\\Seeders\\SeniorityAnniversaryNotificationSeeder',
        ]);
    }
}
