<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class CleanCardsLinksForOrsy extends Migration
{
    public function up(): void
    {
        $fields = [
            "is_featured_in_sidebar",
            "is_featured"
        ];

        $bridgeContentType = new BridgeContentType();
        foreach ($fields as $fieldsName) {
            $bridgeContentType->contentTypeDeleteField(
                entityType: 'node',
                type: 'cards_links',
                fieldName: $fieldsName
            );
        }

        Artisan::call('models:rebuild');
    }
}
