<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixAuditTranslatableContentForOrsy extends Migration
{
    public function up(): void
    {
        $types = [
            "connexion_popups",
            "dms_link",
            "movements",
            "movements_categories",
            "pages",
            "public_pages"
        ];

        $bridgeContentType = new BridgeContentType();
        foreach ($types as $type) {
            $bridgeContentType->contentTypeUpdateOrCreate(
                type: $type,
                options: [
                    'name' => $type,
                    'translatable' => true
                ]
            );
            $bridgeContentType->updateContentTypeOptions(
                type: $type,
                options: [
                    'translatable' => true
                ]
            );
        }

        $bridgeContentType->contentTypeUpdateOrCreate(
            'news_categories_listings',
            [
                'name' => 'news_categories_listings',
                'translatable' => true,
                'searchable' => true,
                'global_searchable' => false,
                'aliasable' => true,
                'permissible' => true,
                'categorizable' => true
            ]
        );

        $bridgeContentType->updateContentTypeOptions(
            type: 'users',
            options: [
                'translatable' => false
            ]
        );
    }
}
