<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFlagFeaturedForCardsLinks extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'cards_links',
            fieldName: 'is_featured_in_sidebar',
            entityTypeId: 'node',
            weight: 4,
            options: [
                'name' => 'is_featured_in_sidebar',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Mettre en avant dans la colonne de gauche',
                    'en' => 'Feature in the left column',
                    'nl' => 'Uitgelicht in de linkerkolom',
                    'pt' => 'Destacar na coluna esquerda',
                    'es' => 'Destacar en la columna izquierda',
                    'de' => 'In der linken Spalte hervorheben',
                ],
                'description' => [
                    'fr' => 'Mettre en avant cette carte dans la colonne de gauche du site.',
                    'en' => 'Feature this card in the left column of the site.',
                    'nl' => 'Deze kaart uitlichten in de linkerkolom van de site.',
                    'pt' => 'Destacar este cartão na coluna esquerda do site.',
                    'es' => 'Destacar esta tarjeta en la columna izquierda del sitio.',
                    'de' => 'Diese Karte in der linken Spalte der Website hervorheben.',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
        );
    }
}
