<?php

namespace Inside\ORSY\Providers;

use Inside\Providers\ServiceProvider as BaseServiceProvider;

/**
 * ORSY Service provider.
 *
 * @category Class
 * @package  Inside\\ORSY\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(__DIR__ . '/../../config/scheduler.php', 'scheduler');
        $this->mergeConfigTo(__DIR__ . '/../../config/statistics.php', 'orsy_statistics');
        $this->mergeConfigTo(__DIR__ . '/../../config/permission.php', 'permission');
        $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
        $this->mergeConfigTo(__DIR__.'/../../config/onelogin.php', 'onelogin');
        $this->mergeConfigTo(__DIR__.'/../../config/csv.php', 'csv');
        $this->mergeConfigTo(__DIR__.'/../../config/xlsx.php', 'xlsx');

        $sid2BaseStatistics = config('sid2_base_statistics');
        $insideStatistics = config('statistics');
        $backStatistics = config('orsy_statistics');
        config(['statistics' => array_replace_recursive($insideStatistics, $sid2BaseStatistics, $backStatistics)]);
    }
}
