<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixPermissibleContentsForOrsy extends Migration
{
    public function up(): void
    {
        $types = [
            "cards_links",
            "spaces_pages"
        ];

        $bridgeContentType = new BridgeContentType();

        foreach ($types as $type) {
            $bridgeContentType->updateContentTypeOptions(
                type: $type,
                options: [
                    'name' => $type,
                    'permissible' => true,
                    'categorizable' => false
                ]
            );
        }
    }
}
