<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'users',
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Utilisateur',
            'en' => 'User',
            'nl' => 'Gebruiker',
            'pt' => 'Utilizador',
            'es' => 'Espace métier',
            'de' => 'Benutzer',
        ],
    ],
    'fields' => [
        [
            'name' => 'initials',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 9,
            'title' => [
                'fr' => 'Initiales Orsys',
                'en' => 'Orsys initials',
                'es' => 'Iniciales Orsys',
                'de' => 'Orsys Initialen',
                'nl' => 'Orsys-initialen',
                'pt' => 'Iniciais Orsys',
            ],
            'widget' => [
                'group' => 'group_infos',
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 6,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'hubs',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Pôle d\'activité',
                'en' => 'Hub',
                'nl' => 'Activiteitencentrum',
                'pt' => 'Pólo de atividade',
                'es' => 'Polo de actividad',
                'de' => 'Geschäftsbereich',
            ],
            'widget' => [
                'group' => 'group_infos',
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 8,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['hubs'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
    ],
];
