<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'users',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'hidden',
        'title' => [
            'fr' => 'Utilisateur',
            'en' => 'User',
            'nl' => 'Gebruiker',
            'pt' => 'Utilizador',
            'es' => 'Espace métier',
            'de' => 'Benutzer',
        ],
    ],
    'fields' => [
        [
            'name' => 'mobile_phone',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 6,
            'title' => [
                'fr' => 'Téléphone mobile',
                'en' => 'Mobile phone',
                'nl' => 'Mobiele telefoon',
                'pt' => 'Telefone móvel',
                'es' => 'Teléfono móvil',
                'de' => 'Handy',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => 6,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'directions',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 7,
            'title' => [
                'fr' => 'Direction',
                'en' => 'Direction',
                'nl' => 'Afdeling',
                'pt' => 'Direção',
                'es' => 'Dirección',
                'de' => 'Abteilung',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 7,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['directions'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'localisations',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Localisation',
                'en' => 'Location',
                'nl' => 'Locatie',
                'pt' => 'Localização',
                'es' => 'Localización',
                'de' => 'Standort',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 8,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['localisations'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'etage',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 9,
            'title' => [
                'fr' => 'Etage',
                'en' => 'Floor',
                'nl' => 'Verdieping',
                'pt' => 'Andar',
                'es' => 'Piso',
                'de' => 'Stockwerk',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 9,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'loisirs',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Loisirs',
                'en' => 'Hobbies',
                'nl' => 'Hobby',
                'pt' => 'Hobbies',
                'es' => 'Aficiones',
                'de' => 'Hobbys',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'teams',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 11,
            'title' => [
                'fr' => 'Teams',
                'en' => 'Teams',
                'nl' => 'Teams',
                'pt' => 'Equipes',
                'es' => 'Equipos',
                'de' => 'Teams',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 11,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'linkedin',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 12,
            'title' => [
                'fr' => 'LinkedIn',
                'en' => 'LinkedIn',
                'nl' => 'LinkedIn',
                'pt' => 'LinkedIn',
                'es' => 'LinkedIn',
                'de' => 'LinkedIn',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 12,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'managers',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 13,
            'title' => [
                'fr' => 'Manager',
                'en' => 'Manager',
                'nl' => 'Manager',
                'pt' => 'Gestor',
                'es' => 'Gerente',
                'de' => 'Manager',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 13,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => 'users',
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],

        [
            'name' => 'is_maintenance',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 14,
            'title' => [
                'fr' => 'Compte de maintenance ?',
                'en' => 'Maintenance account?',
                'nl' => 'Onderhoudsrekening?',
                'pt' => 'Conta de manutenção?',
                'es' => 'cuenta de mantenimiento?',
                'de' => 'Wartungskonto?',
            ],
            'description' => [
                'fr' => 'Si cette case est cochée l\'utilisateur ne remontera pas dans l\'annuaire de l\'intranet',
                'en' => 'If this box is checked the user will not go up in the intranet directory',
                'nl' => 'Als dit vakje is aangevinkt, gaat de gebruiker niet omhoog in de intranetdirectory',
                'pt' => 'Se esta caixa for assinalada, o utilizador não será listado no directório da intranet',
                'es' => 'Si esta casilla está marcada el usuario no subirá en el directorio de la intranet',
                'de' => 'Wenn dieses Kontrollkästchen aktiviert ist, gelangt der Benutzer nicht in das Intranet-Verzeichnis',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 14,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'send_mail',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 15,
            'title' => [
                'fr' => 'Envoyer un mail à la création de mot de passe',
                'en' => 'Send email to password creation',
                'nl' => 'Stuur een e-mail bij het aanmaken van een wachtwoord',
                'pt' => 'Enviar um e-mail para criar uma palavra-passe',
                'es' => 'Enviar correo electrónico a la creación de contraseña',
                'de' => 'E-Mail zur Passworterstellung senden',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 15,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'is_gdpr_compliant',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 16,
            'title' => [
                'fr' => 'RGPD Compliant',
                'en' => 'RGPD Compliant',
                'nl' => 'AVG-compatibel',
                'pt' => 'RGPD Compliant',
                'es' => 'RGPD Compliant',
                'de' => 'RGPD Compliant',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 16,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
    ],
];
