<?php

const ROLE_APPLICATION_INTRANET_INSIDE = 195330;

return [
    'sync_attributes' => [
        'name' => 'username',
        'firstname' => 'firstname',
        'lastname' => 'lastname',
        'mobile_phone' => 'mobile_phone',
        'phone' => 'phone',
        'email' => 'email',
        'function' => 'title',
        'directions' => fn (array $user) => reference('directions')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user['department'] ?? '')))
            ->get(),
        'etage' => 'etage',
        'initials' => 'initials',
        'hubs' => fn (array $user) => reference('hubs')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user['hubs'] ?? '')))
            ->get(),
        'localisations' => fn (array $user) => reference('localisations')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user['localisations'] ?? '')))
            ->get(),
        'managers' => fn (array $user) => reference('users')
            ->identifiedBy('email')
            ->from($user['managers'] ?? '')
            ->withoutCreation()
            ->get(),
    ],

    'custom_attributes' => [
        'mobile_phone' => 'mobile',
        'localisations' => 'locality',
        'etage' => 'office',
        'phone' => 'telephone_number',
        'initials' => 'sales_initials',
        'hubs' => 'division',
        'roleIds' => 'roleIds'
    ],

    'manager_attributes' => [
        'managers' => 'email'
    ],

    'postfilter' => function (\Illuminate\Support\Collection $users) {
        return $users->reject(function (\OneLogin\api\models\User $user) {
            return $user->comment === '_Desactiver' || !in_array(ROLE_APPLICATION_INTRANET_INSIDE, $user->roleIds);
        });
    }
];
