import { http } from '@inside-library/helpers/Http'

const fetchNewsSlider = async () => {
  try {
    const { data } = await http.get('content/news', {
      fields: [
        'uuid',
        'title',
        'slug',
        'published_at',
        'chapo',
        'image',
        'content_type',
        {
          news_categories: {
            fields: ['uuid', 'title'],
            filters: { 'status:eq': true }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'is_featured:eq': 1,
        'published_at:lte': 'now()',
        limit: 5,
        sort: 'published_at:desc'
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchNewsSlider }
