import EditionManagerSpacePage from '../pages/space/EditionManagerSpacePage'

import { withFetch } from 'inside-collection/hocs'
import { fetchManagerSpaces } from '../fetch'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: { filtersInput: 'selectbox' }
  },
  {
    name: 'NewsPage',
    component: () => import('../pages/news/NewsPage'),
    meta: { disabled: false, content: 'news' }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'GedMarketingPage',
    path: {
      fr: '/communication',
      de: '/kommunikation'
    },
    alias: 'marketing_folders',
    component: () => import('../pages/ged/GedMarketingPage'),
    meta: { disabled: false }
  },
  {
    name: 'GedBuyerPage',
    path: {
      fr: '/achats',
      de: '/einkaufen'
    },
    alias: 'buyer_folders',
    component: () => import('../pages/ged/GedBuyerPage'),
    meta: { disabled: false }
  },
  {
    name: 'ManagerSpaceListingPage',
    path: {
      fr: '/espace-manager',
      de: '/manager-raum'
    },
    component: () => import('../pages/space/ManagerSpaceListingPage')
  },
  {
    name: 'ManagerSpacePage',
    path: {
      fr: '/espace-manager/:slug',
      de: '/manager-raum/:slug'
    },
    component: () => import('../pages/space/ManagerSpacePage'),
    meta: { content: 'manager_spaces' }
  },
  {
    name: 'EditionManagerSpacePage',
    path: {
      fr: '/edition-espace-manager',
      de: '/ausgabe-raum-manager'
    },
    component: withFetch(EditionManagerSpacePage, { size: 'xxl' })(
      fetchManagerSpaces
    )
  },
  {
    name: 'EventsCalendarPage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'EventPage',
    component: () => import('../pages/events/EventPage'),
    meta: {
      disabled: false,
      content: 'events'
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  }
]
