export default {
  buyingConditions: {
    add: () => ({ name: 'ManagerSpaceListingPage' }),
    delete: () => ({ name: 'ManagerSpaceListingPage' })
  },
  marketingDocuments: {
    fields: [{ marketing_folders: ['uuid'] }],
    add: ({ fields }) => ({
      name: 'GedMarketingPage',
      query: { folder: fields.marketing_folders[0] }
    }),
    delete: ({ data }) => ({
      name: 'GedMarketingPage',
      query: { folder: data.marketing_folders.data[0].uuid }
    }),
    globalSearch: ({ vm, data }) => ({
      action: () =>
        vm.triggerModal(
          'doc-ged',
          'fetch',
          { item: data, content: data.content_type },
          { layout: 'right', transition: 'fadeInLeft' }
        )
    })
  },
  marketingFolders: {
    fields: ['uuid', { marketing_folders: ['uuid'] }],
    add: ({ data }) => ({
      name: 'GedMarketingPage',
      query: {
        folder: data.uuid
      }
    }),
    delete: ({ data }) => ({
      name: 'GedMarketingPage',
      query: {
        folder:
          data.marketing_folders.data[0] && data.marketing_folders.data[0].uuid
      }
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  buyerDocuments: {
    fields: [{ buyer_folders: ['uuid'] }],
    add: ({ data }) => ({
      name: 'GedBuyerPage',
      query: { folder: data.buyer_folders.data[0].uuid }
    }),
    delete: ({ data }) => ({
      name: 'GedBuyerPage',
      query: { folder: data.buyer_folders.data[0].uuid }
    }),
    globalSearch: ({ vm, data }) => ({
      action: () =>
        vm.triggerModal(
          'doc-ged',
          'fetch',
          { item: data, content: data.content_type },
          { layout: 'right', transition: 'fadeInLeft' }
        )
    })
  },
  buyerFolders: {
    fields: ['uuid', { buyer_folders: ['uuid'] }],
    add: ({ data }) => ({
      name: 'GedBuyerPage',
      query: {
        folder: data.uuid
      }
    }),
    delete: ({ data }) => ({
      name: 'GedBuyerPage',
      query: {
        folder: data.buyer_folders.data[0] && data.buyer_folders.data[0].uuid
      }
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  managerSpaces: {
    add: ({ data }) => ({
      name: 'ManagerSpacePage',
      params: {
        slug: data.slug[0]
      }
    }),
    delete: () => ({ name: 'ManagerSpaceListingPage' })
  },
  managerSpacesDocuments: {
    fields: [
      { manager_spaces_folders: ['uuid', { manager_spaces: ['uuid', 'slug'] }] }
    ],
    add: ({ data }) => ({
      name: 'ManagerSpacePage',
      params: {
        slug: data.manager_spaces_folders.manager_spaces.slug[0],
        folder: data.manager_spaces_folders.uuid
      }
    }),
    delete: ({ data }) => ({
      name: 'ManagerSpacePage',
      params: {
        slug: data.manager_spaces_folders.manager_spaces.slug[0],
        folder: data.manager_spaces_folders.uuid
      }
    }),
    globalSearch: ({ vm, data }) => ({
      action: () =>
        vm.triggerModal(
          'doc-ged',
          'fetch',
          { item: data, content: data.content_type },
          { layout: 'right', transition: 'fadeInLeft' }
        )
    })
  },
  managerSpacesFolders: {
    fields: [{ manager_spaces: ['uuid', 'slug'] }],
    add: ({ data }) => ({
      name: 'ManagerSpacePage',
      params: {
        slug: data.manager_spaces.slug[0]
      }
    }),
    delete: ({ data }) => ({
      name: 'ManagerSpacePage',
      params: {
        slug: data.manager_spaces.slug[0]
      }
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  }
}
