export default {
  jobs: {
    extendedUrl: ['slug'],
    modalFields: [
      'title',
      'content',
      { author: ['uuid', 'lastname', 'firstname'] },
      'uuid',
      'slug',
      'content_type',
      'published_at',
      'email',
      'status',
      'date',
      'langcode',
      { services: ['uuid', 'title'] },
      { localisation: ['uuid', 'title'] },
      'uuid'
    ]
  },
  modal: {
    modalFields: ['class', 'content']
  },
  tools: {
    staticFields: [
      'title',
      'tools_link',
      'tree',
      'color',
      'image',
      'icon',
      'status'
    ]
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'email',
      'status',
      'firstname',
      'address',
      'uuid',
      'hobby',
      'arrival_date',
      'lastname',
      'image',
      'function',
      'spoken_languages',
      'hobbies',
      'phone',
      'mobile',
      'access_map',
      'facebook',
      'linkedin',
      'instagram',
      'youtube',
      'contact',
      {
        services: ['uuid', 'slug', 'title']
      },
      {
        localisation: ['title', 'uuid']
      },
      {
        sites: ['title', 'uuid', 'slug']
      },
      {
        users: ['firstname', 'lastname', 'uuid', 'function', 'image']
      }
    ]
  },
  manager_spaces_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  buyer_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  marketing_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  }
}
