<?php

namespace Inside\OPTI\Providers;

use Inside\OPTI\Http\Middleware\LimitManagerToHisOwnSpaces;
use Illuminate\Support\Facades\Event;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\OPTI\Events\GlobalManagersDocumentsUpdatedEvent;
use Inside\OPTI\Events\SpaceManagersDocumentsUpdatedEvent;
use Inside\OPTI\Listeners\ContentInsertedListener;
use Inside\OPTI\Listeners\GlobalManagersDocumentsUpdatedListener;
use Inside\OPTI\Listeners\SpaceManagersDocumentsUpdatedListener;
use Inside\Support\EventServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * OPTI Service provider.
 *
 * @category Class
 * @package  Inside\OPTI\Providers\ServiceProvider
 * @author   Maecia <contact@feldoe.net>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends EventServiceProvider
{
    protected array $listen = [
        ContentInsertedEvent::class => [
            ContentInsertedListener::class,
        ],
        GlobalManagersDocumentsUpdatedEvent::class => [
            GlobalManagersDocumentsUpdatedListener::class,
        ],
        SpaceManagersDocumentsUpdatedEvent::class => [
            SpaceManagersDocumentsUpdatedListener::class,
        ],
    ];

    public function register(): void
    {
        try {
            $this->loadMigrationsFrom(__DIR__.'/../../database/migrations');
            $this->mergeConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
            $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->middleware([
            LimitManagerToHisOwnSpaces::class
        ]);
    }
}
