<?php

namespace Inside\OPTI\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Authentication\Models\User;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;
use Inside\OPTI\Events\GlobalManagersDocumentsUpdatedEvent;

class GlobalManagersDocumentsUpdatedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(GlobalManagersDocumentsUpdatedEvent $event): void
    {
        $users = \Inside\Permission\Models\User::all();
        $managers = $users->filter(function ($user) {
            return $user->hasRole('manager');
        });
        /** @var NotificationType $notificationType */
        $notificationType = NotificationType::where([
            'event' => 'Inside\OPTI\Events\GlobalManagersDocumentsUpdatedEvent',
            'type' => 'system',
            'action' => 'managerSpacesGlobalDocuments'
        ])->first();
        $managers->each(function ($manager) use ($notificationType, $event) {
            /** @var User $user */
            $user = User::find($manager->uuid);
            $this->route = $user;
            $this->notify($notificationType, $user, null, [
               'custom' => $event->field
           ]);
        });
    }
}
