<?php

namespace Inside\OPTI\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Host\Bridge\BridgeContent;

class ContentInsertedListener implements ShouldQueue
{
    /**
     * @param mixed $model
     * @return array
     */
    public function setDefaultFolders($model): array
    {
        $datas = [];
        if ($model->langcode === "fr") {
            $datas = [
                'Mes achats' => [
                    'Reporting par fournisseur a date',
                    'commandes ES à venir',
                    'Bon de commande N+1'
                ],
                'Mon activité' => [
                    'PDF stats magasin',
                    'Analyse financière du dernier bilan'
                ],
                'Mes factures' => [
                    'Facture Audioptic'
                ],
                'Mes informations contractuelles' => [
                    'Contrat de Franchise',
                    'Zone de chalandise',
                    'Taux de pénétration / carte',
                    'Mon cahier codes optic 2000'
                ],
                'Mes informations marché' => [
                    'Benchmark',
                    'Bonnes pratiques'
                ],
                'La formation de mes équipes' => [],
                'Communication locale' => []
            ];
        } elseif ($model->langcode === "de") {
            $datas = [
                'Meine Einkäufe' => [
                    'Bisherige Berichterstattung',
                    'Ihre Fassungsbestellung, die geplanten systematischen Versände',
                    'Bestellformular N+1'
                ],
                'Meine Aktivitäten/ Mein Geschäft' => [
                    'Finanzanalyse der letzten Bilanz',
                    'PDF Geschäftsstatistiken'
                ],
                'Meine Rechnungen' => [
                    'Rechnungen Optic Swiss Services SA'
                ],
                'Meine vertraglichen Informationen' => [
                    'Exklusivitätsgebiet / Karte',
                    'Franchisevertrag',
                    'Penetrationsrate',
                    'Mein Optic 2000 Codes-Handbuch'
                ],
                'Meine Marktinformationen' => [
                    'Benchmark',
                    'Bewährte Praktiken'
                ],
                'Die Weiterbildung meines Teams' => [],
                'Lokale Kommunikation' => [
                    'Formular zur Verfolgung lokaler Werbeinvestitionen'
                ]
            ];
        }
        return $datas;
    }

    public function handle(ContentInsertedEvent $event): void
    {
        $model = $event->model;

        if ($model->content_type == "manager_spaces") {
            $bridge = new BridgeContent();
            $uuid = $bridge->contentInsert("manager_spaces_folders", [
                'title'             => $model->title,
                'manager_spaces'    => $model->uuid,
                'type' => 'node',
                'langcode' => $model->langcode,
                'bundle' => 'manager_spaces_folders'
            ]);
            if ($uuid) {
                $datas = $this->setDefaultFolders($model);

                $chunkId = Str::random(32);
                $path = cms_base_path(env('APP_STORAGE_PATH', storage_path()) . '/chunks/' . $chunkId);
                File::makeDirectory($path);

                foreach ($datas as $main_folder => $subfolders) {
                    $parent = $bridge->contentInsert("manager_spaces_folders", [
                        'title' => $main_folder,
                        'manager_spaces' => $model->uuid,
                        'manager_spaces_folders' => $uuid,
                        'type' => 'node',
                        'langcode' => $model->langcode,
                        'bundle' => 'manager_spaces_folders'
                    ]);
                    foreach ($subfolders as $folders) {
                        $bridge->contentInsert("manager_spaces_folders", [
                            'title' => $folders,
                            'manager_spaces' => $model->uuid,
                            'manager_spaces_folders' => $parent,
                            'langcode' => $model->langcode,
                            'type' => 'node',
                            'bundle' => 'manager_spaces_folders'
                        ]);
                    }
                    if ($main_folder === "Communication locale") {
                        File::copy('vendor/maecia/opti-back/resources/budget.xlsx', $path . '/' . 'budget.xlsx');

                        $bridge->contentInsert('manager_spaces_documents', [
                           'title' => 'tableau de budget',
                            'file' => 'chunks/' . $chunkId . '/budget.xlsx',
                            'manager_spaces_folders' => $parent,
                            'type' => 'node',
                            'bundle' => 'manager_spaces_documents'
                        ]);
                    }
                }
            }
        }
    }
}
