<?php

namespace Inside\OPTI\Http\Controllers;

use Illuminate\Http\Request;
use Inside\OPTI\Services\ManagerSpacesService;
use Laravel\Lumen\Routing\Controller;

class ManagerSpacesController extends Controller
{
    /**
     * The Form service.
     *
     * @var ManagerSpacesService
     */
    protected $service;

    /**
     * Create a new form controller instance.
     */

    public function __construct()
    {
        $this->service = new ManagerSpacesService();
    }

    public function addManagerDocs(Request $request): array
    {
        return $this->service->addManagerDocs($request->toArray());
    }

    public function getSpace(Request $request, string $space): array
    {
        // get this space docs
        return $this->service->getSpace($request->toArray(), $space);
    }

    public function getAllSpaces(Request $request): array
    {
        // get all documents : should I get the uuids from the request
        return $this->service->getAllSpaces($request->toArray());
    }
}
