<?php

namespace Inside\OPTI\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class SpaceManagersDocumentsUpdatedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * @var string
     */
    public $space_uuid;

    public function __construct(string $space_uuid)
    {
        $this->space_uuid = $space_uuid;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('opti_inside_space_documents_updated');
    }
}
