<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class AddSomeCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $pages =  [
            [
                'title' => 'Actualités',
                'custom_slug' => 'news',
                'redirection_page' => 'NewsListingPage'
            ],
            [
                'title' => 'Événements',
                'custom_slug' => 'calendar',
                'redirection_page' => 'EventsCalendarPage'
            ],
            [
                'title' => 'Bibliothèque',
                'custom_slug' => 'ged',
                'redirection_page' => 'GedPage'
            ],
            [
                'title' => 'Annuaire',
                'custom_slug' => 'directory',
                'redirection_page' => 'DirectoryPage'
            ]
        ];
        foreach ($pages as $page) {
            $bridge->contentInsert('custom', [
                'langcode' => 'fr',
                'title' => $page['title'],
                'custom_slug' => $page['custom_slug'],
                'redirection_page' => $page['redirection_page']
            ]);
        }
    }
}
