<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;

class FixNewsletters extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $this->writeln('<fg=magenta>Correction des newsletters</fg=magenta>');
        $bridge = new BridgeContentType();
        $this->write('Cacher la sélection de la <fg=cyan>langue</fg=cyan> dans les newsletters');
        try {
            $this->writeResult($bridge->changeFieldFormOptions('newsletters', 'langcode', false));
        } catch (Exception $e) {
            $this->writeResult(false);
        }

        $this->write('Cacher la sélection des <fg=cyan>roles</fg=cyan> dans les newsletters');
        try {
            $this->writeResult($bridge->changeFieldFormOptions('newsletters', 'newsletter_roles', false));
        } catch (Exception $e) {
            $this->writeResult(false);
        }

        if (!InsideSchema::hasField('newsletters', 'body_de')) {
            $this->write('Ajout du champ <fg=cyan>body_de</fg=cyan>');
            $this->writeResult(
                $bridge->contentTypeCreateOrUpdateField(
                    'newsletters',
                    'body_de',
                    [
                        'name'                => 'body_de',
                        'searchable'          => false,
                        'translatable'        => false,
                        'default'             => '',
                        'search_result_field' => false,
                        'required'            => false,
                        'weight'              => 2,
                        'title'               => [
                            'fr' => 'Introduction ( Allemand )',
                            'de' => 'Einführung ( deutsch )',
                        ],
                        'description'         => [],
                        'widget'              => [
                            'type'     => BridgeContentType::WYSIWYG_WIDGET,
                            'settings' => [
                                'rows'         => 9,
                                'summary_rows' => 3,
                                'placeholder'  => '',
                            ],
                        ],
                        'type'                => BridgeContentType::WYSIWYG_FIELD,
                        'settings'            => [
                            'cardinality' => 1,
                        ],
                    ]
                )
            );
        }
        // Réparation du formulaire
        $this->write('Correction de l\'ordre des champs');
        $this->writeResult($bridge->reorderFields('newsletters', [
            'title',
            'body',
            'body_de',
            'news',
            'events',
            'status',
            'authors',
            'created_at',
        ]));

        // Repair published
        if (InsideSchema::hasField('newsletters', 'status')) {
            $this->write(
                'Réparation du champ <fg=magenta>publié</fg=magenta> dans les <fg=cyan>newsletter</fg=cyan>'
            );
            $this->writeResult($bridge->changeFieldFormOptions('newsletters', 'status', true, 'group_options'));
        }

        // Repair created_at
        if (InsideSchema::hasField('newsletters', 'created_at')) {
            $this->write(
                'Réparation du champ <fg=magenta>créé le</fg=magenta> dans les <fg=cyan>newsletter</fg=cyan>'
            );
            $this->writeResult($bridge->changeFieldFormOptions('newsletters', 'created_at', true, 'group_options'));
        }

        // Repair author
        if (InsideSchema::hasField('newsletters', 'authors')) {
            $this->write(
                'Réparation du champ <fg=magenta>créé par</fg=magenta> dans les <fg=cyan>newsletter</fg=cyan>'
            );
            $this->writeResult($bridge->changeFieldFormOptions('newsletters', 'authors', true, 'group_options'));
        }
    }

    public function down(): void
    {
    }
}
