<?php

return [
  'files' => [
    'opti' => [
      'path'      => __DIR__ . '/../../../../imports/import.csv',
      'separator' => ';',
      'fields'    => [
        'name' => 'email',
        'mail' => 'email',
        'firstname' => fn ($record) => str($record['prénom'])->trim()->lower()->title()->toString(),
        'lastname' => fn ($record) => str($record['nom'])->trim()->lower()->title()->toString(),
        'localisation' => fn ($record) => reference('localisation')->from(str($record['localisation'])->trim()->lower()->title()->toString())->get(),
        'profiles' => fn ($record) => reference('profiles')->from(str($record['profil'])->trim()->lower()->title()->toString())->get(),
        'activities' => fn ($record) => reference('activities')->from(str($record['fonction'])->trim()->lower()->title()->toString())->get(),
        'shop' => 'magasin',
        'company' => 'société',
        'phone' => fn ($record) => str($record['téléphone'])->trim(),
        'status' => fn () => 1
      ]
    ]
  ]
];
