<?php

namespace Inside\OPTI\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * @property string $space_uuid
 * @property string|null $file
 * @property string $label
 * @property string $field
 * @property int $created_at
 * @property int $updated_at
 */
class ManagerSpace extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_opti_manager';

    /**
     * Casts the following attributes
     *
     * @var array
     */
    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'space_uuid',
        'file',
        'label',
        'field'
    ];
}
