<?php

namespace Inside\OPTI\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Contents\ManagerSpaces;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;
use Inside\OPTI\Events\SpaceManagersDocumentsUpdatedEvent;
use Inside\Authentication\Models\User;

class SpaceManagersDocumentsUpdatedListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(SpaceManagersDocumentsUpdatedEvent $event): void
    {
        $space = ManagerSpaces::find($event->space_uuid);
        if (!$space) {
            return;
        }

        /** @var NotificationType $notificationType */
        $notificationType = NotificationType::where([
            'event' => 'Inside\OPTI\Events\SpaceManagersDocumentsUpdatedEvent',
            'type' => 'system',
            'action' => 'managerSpaceDocument'
        ])->first();

        $managers = $space->users;

        $slug = DB::table('inside_slugs')->where('uuid', $space->uuid)->where('type', 'inside_content_manager_spaces')
            ->pluck('slug')->first();

        $managers->each(function ($manager) use ($notificationType, $space, $slug) {
            /** @var User $user */
            $user = User::find($manager->uuid);
            $this->route = $user;
            $this->notify($notificationType, $user, null, [
                'space' => $space->title,
                'url' => $slug
            ]);
        });
    }
}
