<?php

namespace Inside\OPTI\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Inside\Slug\Facades\Slug;
use Inside\Support\Str;
use Symfony\Component\HttpFoundation\Response;

class LimitManagerToHisOwnSpaces
{
    public function handle(Request $request, Closure $next): Response
    {
        if (
            $request->method() !== 'GET' ||
            ! Str::of($request)->contains('api/v1/content/manager_spaces?') ||
            ! Str::of($request->input('filters'))->contains('slug') ||
            $request->user()->isSuperAdmin()
        ) {
            return $next($request);
        }

        $slug = collect(json_decode($request->input('filters'), true))->get('slug');
        $uuid = Slug::getUuid('inside_content_manager_spaces', (string) $slug);

        $userCanAccess = DB::table('inside_pivots')
            ->where('parent_uuid', $uuid)
            ->where('related_uuid', $request->user()->uuid)
            ->exists();

        if ($userCanAccess) {
            return $next($request);
        }

        return response()->json(['data' => []], 200);
    }
}
