<?php

namespace Inside\OPTI\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class GlobalManagersDocumentsUpdatedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * @var string
     */
    public $field;

    public function __construct(string $field)
    {
        $this->field = $field;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('opti_inside_global_documents_updated');
    }
}
