<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class OptiTranslateParagraphs extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('paragraph', 'call_to_action', 'link');

        collect([
            'call_to_action' => [
                [
                    'name' => 'title',
                    'title' => [
                        'fr' => 'Titre',
                        'de' => 'Titel'
                    ],
                    'weight' => 1,
                ],
                [
                    'name' => 'cta_link',
                    'title' => [
                        'fr' => 'Lien',
                        'de' => 'Link'
                    ],
                    'weight' => 2,
                ],
                [
                    'name' => 'link_title',
                    'title' => [
                        'fr' => 'Titre du lien',
                        'de' => 'Titel des Links'
                    ],
                    'weight' => 3,
                ],
                [
                    'name' => 'body',
                    'title' => [
                        'fr' => 'Texte',
                        'de' => 'Text'
                    ],
                    'weight' => 4,
                    'type' => BridgeContentType::WYSIWYG_FIELD
                ]
            ],
            'file' => [
                [
                    'name' => 'description',
                    'title' => [
                        'fr' => 'Description',
                        'de' => 'Beschreibung'
                    ],
                    'weight' => 2,
                ],
            ],
            'text_with_image' => [
                [
                    'name' => 'display',
                    'title' => [
                        'fr' => 'Affichage',
                        'de' => 'Anzeige'
                    ],
                    'weight' => 1,
                ],
            ],
            'image' => [
                [
                    'name' => 'image_link',
                    'title' => [
                        'fr' => "Lien de l'image",
                        'de' => 'Link zur Bildquelle'
                    ],
                    'weight' => 2,
                ],
            ],
            'slide' => [
                [
                    'name' => 'title',
                    'title' => [
                        'fr' => 'Titre',
                        'de' => 'Titel'
                    ],
                    'weight' => 1,
                ],
            ],
            'map' => [
                [
                    'name' => 'latitude',
                    'title' => [
                        'fr' => 'Latitude',
                        'de' => 'Latitude'
                    ],
                    'weight' => 1,
                ],                [
                    'name' => 'longitude',
                    'title' => [
                        'fr' => 'Longitude',
                        'de' => 'Longitude'
                    ],
                    'weight' => 2,
                ],
                [
                    'name' => 'place',
                    'title' => [
                        'fr' => 'Localisation',
                        'de' => 'Ort'
                    ],
                    'weight' => 3,
                ],
                [
                    'name' => 'address',
                    'title' => [
                        'fr' => 'Adresse',
                        'de' => 'Adresse'
                    ],
                    'weight' => 4,
                ],
            ],
            'accordion' => [
                [
                    'name' => 'question',
                    'title' => [
                        'fr' => 'Question',
                        'de' => 'Frage'
                    ],
                    'weight' => 1,
                ],
            ],
            'button' => [
                [
                    'name' => 'button_text',
                    'title' => [
                        'fr' => 'Texte du lien',
                        'de' => 'Text des Links'
                    ],
                    'weight' => 1,
                ],
                [
                    'name' => 'button_uri',
                    'title' => [
                        'fr' => 'Url du lien',
                        'de' => 'Link'
                    ],
                    'weight' => 2,
                ],
                [
                    'name' => 'button_alignment',
                    'title' => [
                        'fr' => 'Alignement',
                        'de' => 'Ausrichtung'
                    ],
                    'weight' => 3,
                ],
                [
                    'name' => 'button_color',
                    'title' => [
                        'fr' => 'Couleur',
                        'de' => 'Farbe'
                    ],
                    'weight' => 4,
                ],
                [
                    'name' => 'open_in_new_tab',
                    'title' => [
                        'fr' => 'Ouvrir dans un nouvel onglet',
                        'de' => 'In neuer Registerkarte öffnen'
                    ],
                    'weight' => 5,
                ]
            ],
            'tweet' => [
                [
                    'name' => 'tweet_id',
                    'title' => [
                        'fr' => 'ID du Tweet',
                        'de' => 'Tweet ID'
                    ],
                    'weight' => 1,
                ],
            ]
        ])->each(function ($fields, $type) use ($bridge) {
            collect($fields)->each(function ($attr) use ($type, $bridge) {
                $attr['translatable'] = true;
                $bridge->contentTypeCreateOrUpdateField(
                    $type,
                    $attr['name'],
                    $attr,
                    $attr['weight'],
                    'paragraph'
                );
            });
        });
    }
}
