<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class UpdateUsersFieldsTypo extends Migration
{
    public function up(): void
    {
        $fields = collect([
            "access_map" => [
                "fr" => "Plan accès",
                "de" => "Zugangsplan",
            ],
            "activities" => [
                "fr" => "Activité",
                "de" => "Aktivität",
            ],
            "company" => [
                "fr" => "Société",
                "de" => "Firma",
            ],
            "contact" => [
                "fr" => "Contact magasin",
                "de" => "Shop-Kontakt",
            ],
            "facebook" => [
                "fr" => "Facebook",
                "de" => "Facebook",
            ],
            "firstname" => [
                "fr" => "Prénom",
                "de" => "Vorname",
            ],
            "image" => [
                "fr" => "Image",
                "de" => "Bild",
            ],
            "instagram" => [
                "fr" => "Instagram",
                "de" => "Instagram",
            ],
            "is_gdpr_compliant" => [
                "fr" => "GDPR Compliant",
                "de" => "GDPR-konform",
            ],
            "is_maintenance" => [
                "fr" => "Est un compte de maintenance ?",
                "de" => "Ist ein Wartungskonto?",
            ],
            "lastname" => [
                "fr" => "Nom",
                "de" => "Nachname",
            ],
            "linkedin" => [
                "fr" => "Linkedin",
                "de" => "Linkedin",
            ],
            "localisation" => [
                "fr" => "Localisation",
                "de" => "Lage",
            ],
            "mobile" => [
                "fr" => "Mobile",
                "de" => "Mobiltelefon",
            ],
            "phone" => [
                "fr" => "Téléphone",
                "de" => "Telefon",
            ],
            "profiles" => [
                "fr" => "Profil",
                "de" => "Profil",
            ],
            "send_mail" => [
                "fr" => "Envoyer un mail de création de mot de passe",
                "de" => "Senden Sie eine E-Mail zur Passworterstellung",
            ],
            "shop" => [
                "fr" => "Magasin",
                "de" => "Geschäft",
            ],
            "shortcuts_menus" => [
                "fr" => "Accès rapides",
                "de" => "Schnellzugriffe",
            ],
            "tools" => [
                "fr" => "Mes accès rapides",
                "de" => "Meine Schnellzugriffe",
            ],
            "youtube" => [
                "fr" => "Youtube",
                "de" => "Youtube",
            ],
        ]);

        $bridge = new BridgeContentType();

        $fields->each(fn ($options, $field) => $bridge->changeFieldTitle('users', $field, $options));
    }
}
