<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class FixTranslatableDocuments extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField('buyer_documents', 'file', ['translatable' => true]);
        $this->getBridge()?->contentTypeCreateOrUpdateField('marketing_documents', 'file', ['translatable' => true]);
        $this->finishUp();
    }
}
