<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\ManagerSpaces;
use Inside\Content\Models\Contents\ManagerSpacesFolders;
use Inside\Host\Bridge\BridgeContent;

class AddDefaultBudgetFileToManagerSpaces extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        ManagerSpacesFolders::query()->where('title', 'Formulaire de suivi des investissements publicitaires locaux')
            ->get()->map(function ($folder) use ($bridge) {
                $bridge->contentDelete('manager_spaces_folders', $folder->uuid);
            });
        $folders = ManagerSpacesFolders::query()->where('title', 'Communication locale')->get();

        foreach ($folders as $folder) {
            $chunkId = Str::random(32);
            $path = cms_base_path(env('APP_STORAGE_PATH', storage_path()) . '/chunks/' . $chunkId);
            File::makeDirectory($path);

            File::copy('vendor/maecia/opti-back/resources/budget.xlsx', $path . '/' . 'budget.xlsx');

            $bridge->contentInsert('manager_spaces_documents', [
                'title' => 'tableau de budget',
                'file' => 'chunks/' . $chunkId . '/budget.xlsx',
                'manager_spaces_folders' => $folder->uuid,
                'type' => 'node',
                'bundle' => 'manager_spaces_documents'
            ]);
        }
    }

    public function down(): void
    {
    }
}
