<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInsideOptiManager extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('inside_opti_manager', function (Blueprint $table) {
            $table->increments('id');
            $table->string('space_uuid');
            $table->string('field');
            $table->string('label')->nullable();
            $table->string('file', 255)->nullable();
            $table->timestamps();
            $table->index('space_uuid');
            $table->index('field');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_opti_manager');
    }
}
