<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Content\Models\Field;

class FixDrupalConfig extends Migration
{
    /**
     * @var string[]
     */
    protected $overrides = [
        'status',
        'sticky',
        'uid',
        'title',
    ];

    protected function fixConfig(string $key, string $lang = 'fr'): void
    {
        $config = DB::table('config')->where('name', $key)->first();
        if (!$config) {
            return;
        }
        $config             = unserialize($config->data);

        if ($config['langcode'] == $lang) {
            return;
        }

        if (array_key_exists('translatable', $config)) {
            $config['translatable'] = true;
        }
        // Need to be fixed !
        $config['langcode'] = $lang;
        DB::table('config')->where('name', $key)->update(
            [
                'data' => serialize($config),
            ]
        );
    }

    protected function fixConfigs(string $cat, array $types): void
    {
        foreach ($types as $type) {
            if ($type == 'comments') {
                continue;
            }

            if ($cat == 'paragraph') {
                $this->fixConfig('paragraphs.paragraphs_type.' . $type);
            } elseif ($type == 'users') {
                $this->fixConfig('user.settings');
                $this->fixConfig('user.mail');
                $this->fixConfig('user.flood');
            } else {
                $this->fixConfig($cat . '.type.' . $type);
            }
            $this->fixConfig('language.content_settings.'.($type == 'users' ? 'user' : $cat) . '.' . ($type == 'users' ? 'user'
                                 : $type));


            DB::table('config')->where(
                'name',
                'like',
                'core.base_field_override.' . ($type == 'users' ? 'user' : $cat) . '.' . ($type == 'users' ? 'user'
                    : $type) . '.%'
            )->get()->each(function ($config) {
                $this->fixConfig($config->name);
            });

            foreach (InsideSchema::getFieldListing($type) as $field) {
                if ($field == 'users') {
                    $field = 'user';
                }
                // Storage
                $this->fixConfig('field.storage.' . ($type == 'users' ? 'user' : $cat) . '.field_' . $field);

                // Field
                $this->fixConfig(
                    'field.field.' . ($type == 'users' ? 'user' : $cat) . '.' . ($type == 'users' ? 'user' : $type)
                    . '.field_' . $field
                );
            }
        }
    }

    public function up(): void
    {
        $config = DB::table('config')->where('name', 'node.type.news')->first();

        // Content types
        $this->fixConfigs('node', InsideSchema::getContentTypes());

        // Sections
        $this->fixConfigs('paragraph', InsideSchema::getSectionTypes());

        // Comments
        $this->fixConfig('comment.type.comments');
        foreach (
            ['comment.comment_body', 'comment.field_file', 'node.field_comments', 'node.field_comments_text',] as $storage
        ) {
            $this->fixConfig('field.storage.' . $storage);
        }
        foreach (['field_file', 'comment_body'] as $field) {
            $this->fixConfig('field.field.comment.comments.' . $field);
        }
        $this->fixConfig('language.content_settings.comment.comments');

        // Fix inside fields
        Field::each(
            function ($field) {
                $options                 = $field->options;
                if (!isset($options['title']['fr'])) {
                    $options['title']['fr'] = $options['title']['en'] ?? '';
                }
                if (!isset($options['description']['fr'])) {
                    if (!is_array($options['description'])) {
                        $options['description'] = ['fr' => ''];
                    }
                    $options['description']['fr'] = $options['description']['en'] ?? '';
                }
                $field->options = $options;
                $field->save();
            }
        );
    }

    public function down(): void
    {
    }
}
