<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable' => false,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'name' => 'newsletters',
        'title' => [
            'fr' => 'Newsletters',
        ],
    ],
    'fields' => [
        [
            'name' => 'news',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Actualités',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['news'],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'body',
            'searchable' => false,
            'translatable' => false,
            'default' => '',
            'search_result_field' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Introduction'
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [
                    'rows' => 9,
                    'summary_rows' => 3,
                    'placeholder' => '',
                ],
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'newsletter_roles',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'roles newsletter',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'hidden' => true,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'events',
            'searchable' => false,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Evénements',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => []
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['events'],
                'cardinality' => -1,
            ],
        ],
    ],
];
