<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => true,
        'name' => 'events_categories',
        'title' => [
          'fr' => 'Catégorie d\'événements',
          'de' => 'Catégorie d\'événements',
        ],
    ],
    'fields' => [
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Couleur',
                'de' => 'Couleur',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 8,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'events_categories',
            'searchable' => false,
            'translatable' => true,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => 26,
            'title' => [
                'fr' => 'Catégorie parente',
                'de' => 'Catégorie parente',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                'settings' => [
                    'match_operator' => 'CONTAINS',
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 26,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['events_categories'],
                'cardinality' => -1,
            ],
        ],
    ],
];
