<?php

use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;

return [
    'custom_protected_resource_permissions' => [
        function (string $path) {
            $decomposed = explode('/', trim($path, '/'));
            if ($decomposed[0] == 'managers') {
                /** @var User $me */
                $me = Auth::user();
                /** @var ?User $user */
                $user = \Inside\Permission\Models\User::find($me->uuid);
                if (!$user || (!$user->hasRole('manager') && !$user->isSuperAdmin())) {
                    return false;
                }
            }
        }
    ]
];
