<?php

use Illuminate\Support\Arr;

return [
    'manual_notifications' => [
        'enabled' => true,
        'enhanced_notifications' => true,
        'enhanced_notifications_types_and_fields' => [
            'news' => [
                'fields' => [
                    'image',
                    'chapo',
                ]
            ],
            'events' => [
                'fields' => [
                    'image',
                    'chapo',
                ]
            ],
            'external_notifications' => [
                'fields' => [
                    'image',
                ],
            ],
        ],
        'disabled_types' => [
            'newsletters',
            'groups'
        ],
        'custom_url' => function ($channel, $type, $uuid) {
            $rootContentUuid = match ($type) {
                'marketing_folders', 'buyer_folders' => $uuid,
                'marketing_documents' => call_user_func(type_to_class($type).'::findOrFail', $uuid)->marketingFolders()->first()->uuid,
                'buyer_documents' => call_user_func(type_to_class($type).'::findOrFail', $uuid)->buyerFolders()->first()->uuid,
                default => null,
            };
            $urlAlias = match ($type) {
                'marketing_folders', 'buyer_folders' => $type,
                'marketing_documents' => 'marketing_folders',
                'buyer_documents' => 'buyer_folders',
                default => null,
            };

            if ($rootContentUuid && $urlAlias) {
                return $urlAlias.'?'.http_build_query([config('notify.ged.query') => $rootContentUuid]);
            }

            return null;
        }
    ],
];
