export default {
  globals: {
    notificationRedirectionsContentTypes: ['news'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'NewsPage',
        params: {
          slug: data.slug[0]
        }
      })
    }
  },
  'inside-ged': {
    useV2: true,
    rootRoute: {
      fr: 'outils-supports-conseillers'
    },
    e2e: {
      path: 'outils-supports-conseillers',
      useLinks: false
    }
  },
  'inside-news': {
    bookmarkEnabled: false,
    commentsCountEnabled: false,
    reportEnabled: false,
    templates: {
      fullContent: {
        mainComponent: () => import('./components/news/FullNews'),
        commentsEnabledCondition: () => false
      }
    }
  },
  'inside-forms': {
    surveyDisabledInputs: ['input-on-off'],
    formDisabledInputs: ['input-on-off']
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true
    },
    shortcuts: {
      max: 6,
      defaultCount: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [] },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  },
  'inside-statistics': {
    contentsWithStats: [
      'documents',
      'folders',
      'learn_more',
      'events',
      'forms',
      'dms_link',
      'service_offers',
      'tools',
      'pages',
      'quiz',
      'regions',
      'offer_themes'
    ]
  },
  'inside-layouts': {
    displayInsideVersion: true
  }
}
