import Vue from 'vue'

import insideConfig from './inside.config'
import redirections from './redirections'
import routes from './router'

export default {
  name: 'inside-customs',
  displays: {
    'service-offers-catalog': Vue.component(
      'service-offers-catalog-customs',
      () => import('./components/serviceOffers/ServiceOffersCatalogCustoms')
    )
  },
  modals: {
    'learn-more': Vue.component('learn-more-modal', () =>
      import('./components/serviceOffers/LearnMoreModal')
    ),
    news: Vue.component('news-modal', () => import('./modals/NewsModal')),
    listing: Vue.component('listing-modal', () =>
      import('./modals/ListingModal')
    )
  },
  config: {
    tabs: {}
  },
  insideConfig,
  redirections,
  routes
}
