import { http } from '@inside-library/helpers/Http'

export const fetchQuiz = async () => {
  try {
    const { data } = await http.get('content/quiz', {
      fields: [
        'uuid',
        'title',
        'published_at',
        'updated_at',
        'slug',
        'chapo',
        'quiz_image',
        'quiz_description',
        'content_type',
        'quiz_end_date'
      ],
      filters: {
        limit: 3,
        'status:eq': 1,
        'is_featured:eq': 1,
        'published_at:lte': 'now()',
        sort: 'published_at:desc'
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}
