import FeaturedNewsListingPage from '../pages/news/FeaturedNewsListingPage'

import EmailingPage from '../pages/emailing/EmailingPage'

import ServiceOfferPage from '../pages/services/ServiceOfferPage'

import EventsMapPage from '../pages/events/EventsMapPage'

import {
  fetchRegions,
  fetchFeaturedNews,
  fetchServiceOffer,
  fetchEmailings
} from '../fetch'

import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    component: () => import('../pages/news/NewsListingPage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    component: () => import('../pages/news/NewsPage'),
    meta: { disabled: false }
  },
  {
    name: 'FeaturedNewsListingPage',
    path: '/thematiques-en-avant',
    component: withFetch(FeaturedNewsListingPage, { size: 'xxl' })(
      fetchFeaturedNews
    ),
    meta: { customSlug: 'featuredNews' }
  },
  {
    name: 'EmailingsListingPage',
    path: '/emailings',
    component: () => import('../pages/emailing/EmailingsListingPage'),
    meta: { customSlug: 'emailings' }
  },
  {
    name: 'EmailingPage',
    path: '/emailings/:slug',
    component: withFetch(EmailingPage, { size: 'xxl' })(fetchEmailings)
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: { cardOverlayEnabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'ServiceOffersPage',
    path: '/offre-de-services',
    component: () => import('../pages/services/ServiceOffersPage')
  },
  {
    name: 'ServiceOffersFiltersPage',
    path: '/offre-de-services-filtres',
    component: () => import('../pages/services/ServiceOffersFiltersPage')
  },
  {
    name: 'ServiceOfferPage',
    path: '/offre-de-services/:slug',
    component: withFetch(ServiceOfferPage, { size: 'xxl' })(fetchServiceOffer)
  },
  {
    name: 'EventsCalendarPage',
    component: () => import('../pages/events/EventsListingPage'),
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    component: () => import('../pages/events/EventPage'),
    meta: {
      content: 'events',
      disabled: false
    }
  },
  {
    name: 'EventsMapPage',
    path: '/agenda-carte',
    component: withFetch(EventsMapPage, { size: 'xxl' })(fetchRegions)
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { permissionKey: 'advanced-settings', display: true }
  }
]
