<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Regions;

class RemakeSvgField extends Migration
{
    public function up(): void
    {
        $bridgeType = new BridgeContentType();
        $bridge = new BridgeContent();

        $regions = Regions::all('uuid', 'title', 'svg');

        $bridgeType->contentTypeDeleteField('node', 'regions', 'svg');
        $bridgeType->contentTypeCreateOrUpdateField(
            'regions',
            'svg',
            [
                'name' => 'svg',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Svg',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            1
        );

        foreach ($regions as $region) {
            $bridge->contentUpdate('regions', [
                'bundle' => 'regions',
                'title' => $region->title,
                'uuid' => $region->uuid,
                'svg' => $region->svg
            ]);
        }
    }

    public function down(): void
    {
    }
}
