<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateTargetsFieldInOfferStructures extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'offer_structures',
            'targets',
            [
                'name' => 'targets',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => true,
                'translatable' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Cible',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                ],
                'settings' => [
                    'target_type' => 'targets',
                    'cardinality' => 1,
                ],
            ],
            1
        );
    }

    public function down(): void
    {
    }
}
