<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;

class ImportCatalogFilters extends Migration
{
    /**
     * @var array
     */
    private $contents = [
        'offer_themes' => [
            'Alternance & recrutements',
            'Parcours professionnels & développement des compétences',
            'Soutien à la branche & à l\'entreprise',
        ],
        'staff_sizes' => [
            'Moins de 50 salariés',
            'De 51 à 299 salariés',
            'Plus de 300 salariés',
        ],
        'branches' => [
            '0184 l Imprimerie de labeur et Industries Graphiques',
            '0240 l Personnel des Greffes des tribunaux de commerce',
            '0454 l Remontées mécaniques et domaines skiables',
            '0614 l Industries de la sérigraphie et des procédés d’impression numérique connexes',
            '0733 l Détaillants en chaussures',
            '0759 l Pompes funèbres',
            '0843 l Boulangerie-pâtisserie (entreprises artisanales)',
            '0915 l Sociétés d’expertises en matière d’évaluations industrielles et commerciales',
            '0953 l Charcuterie de détail',
            '0959 l Laboratoires de biologie médicale extra-hospitaliers',
            '0992 l Boucherie, boucherie-charcuterie et boucherie hippophagique, triperie, commerces de volailles et gibiers',
            '0993 l Prothésistes dentaires et personnels des laboratoires de prothèse dentaire',
            '1000 l Personnel des cabinets d’avocats',
            '1043 l Gardiens, concierges et employés d’immeubles',
            '1147 l Personnel des cabinets médicaux',
            '1267 l Pâtisserie',
            '1286 l Confiserie, chocolaterie, biscuiterie (détaillants et détaillants-fabricants)',
            '1404 l Maintenance, distribution et location de matériels agricoles, de travaux publics, de bâtiment et de manutention, de motoculture de plaisance et activités connexes (SDLM)',
            '1408 l Négoce et distribution de combustibles solides, liquides, gazeux et produits pétroliers',
            '1412 l Installation sans fabrication, entretien, réparation, dépannage de matériel aéraulique, thermique, frigorifique et connexes',
            '1483 l Commerce de détail de l’habillement et des articles textiles',
            '1499 l Miroiterie, transformation et négoce du verre',
            '1504 l Poissonnerie',
            '1512 l Promotion Immobilière',
            '1527 l Immobilier',
            '1589 l Mareyeurs-expéditeurs',
            '1605 l Entreprises de désinfection, désinsectisation et dératisation',
            '1611 l Entreprises de logistique de communication écrite directe',
            '1619 l Cabinets dentaires',
            '1621 l Répartition pharmaceutique',
            '1850 l Avocats salariés',
            '1875 l Vétérinaires',
            '1921 l Personnel des huissiers de justice',
            '1951 l Cabinets ou entreprises d’expertises en automobile',
            '1978 l Fleuristes, vente et services des animaux familiers',
            '1982 l Négoce et prestations de services dans les domaines médico-techniques',
            '1996 l Pharmacie d’officine',
            '2098 l Personnel des prestataires de services du secteur tertiaire',
            '2111 l Salariés du particulier employeur',
            '2205 l Notariat',
            '2219 l Taxis - 4932Z',
            '2272 l Assainissement et maintenance industrielle',
            '2329 l Avocats au Conseil d’Etat et à la Cour de Cassation et personnel salarié -non avocat',
            '2332 l Entreprises d’architecture',
            '2395 l Assistants maternels du particulier employeur',
            '2564 l Vétérinaires praticiens salariés',
            '2596 l Coiffure et professions connexes',
            '2697 l Personnel des structures associatives cynégétiques (chasse)',
            '2706 l Personnel des administrateurs & mandataires judiciaires',
            '2785 l Offices des commissaires-priseurs judiciaires et sociétés de ventes volontaires de meubles aux enchères publiques',
            '2978 l Personnel salarié des agences de recherches privées',
            '3013 l Librairie',
            '3032 l Esthétique, cosmétique et enseignement technique et professionnel liés aux métiers',
            '3127 l Entreprises privées de services à la personne',
        ],
        'regions' => [
            'Auvergne-Rhône-Alpes',
            'Bourgogne-Franche-Comté',
            'Bretagne',
            'Centre-Val de Loire',
            'Corse',
            'Grand Est',
            'Hauts-de-France',
            'Île-de-France',
            'Normandie',
            'Nouvelle-Aquitaine',
            'Occitanie',
            'Pays de la Loire',
            'Provence-Alpes-Côte d\'Azur',
            'Guadeloupe',
            'Martinique',
            'Guyane',
            'La Réunion',
            'Mayotte',
        ],
        'offer_structures' => [
            'Être bien informé',
            'Faciliter la prise en charge de mes projets',
            'Mieux recruter & mieux former',
            'Soutenir mon activité',
            'Animer & Informer',
            'Observer',
            'Certifier',
            'Soutenir le développement de votre branche et de vos entreprises',
            'Faciliter votre en relation avec les acteurs clés',
            'Simplifier vos démarches',
        ],
        'individual_types' => [
            'Jeune',
            'Demandeur d\'emploi',
            'Salarié',
        ],
    ];

    public function up(): void
    {
        Artisan::call('models:rebuild');
        $bridge = new BridgeContent();

        foreach ($this->contents as $contentType => $contents) {
            foreach ($contents as $title) {
                $content = call_user_func(type_to_class($contentType) . '::query')->where('title', $title)->first();

                if ($content) {
                    continue;
                }

                $bridge->contentInsert($contentType, [
                    'type' => 'node',
                    'bundle' => $contentType,
                    'title' => $title,
                    'langcode' => config('app.locale'),
                ]);
            }
        }
    }
}
