<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateFiltersConfigForServiceOffers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDelete('page_catalogs');
        $bridge->updateFieldOptions('service_offers', 'staff_sizes', [
            'name' => 'staff_sizes',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Ma taille d\'effectifs',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'staff_sizes',
                'cardinality' => -1,
            ],
        ]);
        $bridge->updateFieldOptions('service_offers', 'branches', [
            'name' => 'branches',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Branche(s)',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'branches',
                'cardinality' => -1,
            ],
        ]);
        $bridge->updateFieldOptions('service_offers', 'targets', [
            'name' => 'targets',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Quelle est la cible ?',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'targets',
                'cardinality' => -1,
            ],
        ]);
        $bridge->updateFieldOptions('service_offers', 'regions', [
            'name' => 'regions',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Région(s) ciblée(s)',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'regions',
                'cardinality' => -1,
            ],
        ]);
        $bridge->updateFieldOptions('service_offers', 'offer_structures', [
            'name' => 'offer_structures',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Structure de l\'offre',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'offer_structures',
                'cardinality' => -1,
            ],
        ]);
        $bridge->updateFieldOptions('service_offers', 'offer_themes', [
            'name' => 'offer_themes',
            'type' => BridgeContentType::REFERENCE_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'filter_widget'       => 'checkboxesgroup',
            'filter_order'        => 1,
            'filter_category'     => '',
            'required' => true,
            'title' => [
                'fr' => 'Thématique(s)',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
            'settings' => [
                'target_type' => 'offer_themes',
                'cardinality' => -1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
