<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddRegionToEvents extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'regions',
            'class',
            [
                'name' => 'class',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Icône'
                ],
                'description' => [
                    'fr' => 'Rentrez le code du picto'
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 2,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            2
        );

        $bridge->contentTypeCreateOrUpdateField(
            'regions',
            'svg',
            [
                'type' => BridgeContentType::LONGTEXT_FIELD,
                'name' => 'svg',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'title' => [
                    'fr' => 'Image svg',
                ],
                'description' => [
                    'fr' => ''
                ],
                'settings' => [
                    'cardinality' => 1
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'weight' => 1,
                ],
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            'regions',
            'region_id',
            [
                'name' => 'region_id',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Id de la région'
                ],
                'description' => [
                    'fr' => 'Identifiant de la région'
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 3,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            'events',
            'regions',
            [
                'name' => 'regions',
                'searchable' => false,
                'translatable' => false,
                'default' => null,
                'search_result_field' => false,
                'required' => true,
                'weight' => 6,
                'title' => [
                    'fr' => 'Région'
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 6
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['regions'],
                    'cardinality' => 1,
                ],
            ],
            6
        );
    }
}
