<?php

namespace Inside\OPCO\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\News;
use Laravel\Lumen\Routing\Controller;
use Inside\Reaction\Facades\Reactions;

class PopinController extends Controller
{
    public function popin(): JsonResponse
    {
        $news = News::where('status', 1)
            ->where('display_in_popin', 1)
            ->orderBy('created_at', 'DESC')
            ->first();
        $user = Auth::user();

        if (empty($news) || !$user instanceof User) {
            return response()->json([
                'popin' => false,
            ]);
        }

        $reaction = DB::table('inside_reactions')
            ->where('type', 'popin')
            ->where('user_uuid', $user->uuid)
            ->where('reactionable_uuid', $news->uuid)
            ->where('created_at', 'LIKE', date('Y-m-d', time()).' %')
            ->orderBy('created_at', 'DESC')->get();

        $count = $reaction->count();

        return response()->json([
            'popin' => $count === 0,
            'reaction_date' => $count === 0 ? null : $reaction->pluck('created_at')->first(),
        ]);
    }

    public function reaction(Request $request): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();
        $uuid = $request->input('uuid');

        $reactions = DB::table('inside_reactions')
            ->where('type', 'popin')
            ->where('user_uuid', $user->uuid)
            ->orderBy('created_at', 'DESC')->get();

        $data = News::findOrFail($uuid);
        if ($reactions->count()) {
            foreach ($reactions as $reaction) {
                Reactions::delete('popin', $reaction->reactionable_uuid, $reaction->user_uuid, $reaction->langcode);
            }
        }


        return response()->json(Reactions::create([
            'user_uuid' => $user->uuid,
            'reactionable_uuid' => $uuid,
            'reactionable_type' => News::class,
            'type' => 'popin',
            'langcode' => $data->langcode,
        ]));
    }
}
