<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddContentTypeEmailingsCategories extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('emailings_categories');

        $this->getBridge()?->contentTypeDeleteField('node', 'emailings', 'news');
        $this->getBridge()?->contentTypeCreateOrUpdateField('emailings', 'emailings_categories', [
            'name' => 'emailings_categories',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'title' => [
                'fr' => "Théamtique d'emailing",
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'group' => 'group_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['emailings_categories'],
                'cardinality' => 1,
            ],
        ]);

        $this->finishUp();
    }
}
