<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class EditEmailingsContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('emailings_targets');
        $this->migrateContent('emailings');

        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeDeleteField('node', 'emailings', 'chapo');

        $emailingsTargets = [
            'entreprise',
            'prestataire de formation',
            'expert comptable',
            'autres',
        ];

        $bridgeContent = new BridgeContent();

        foreach ($emailingsTargets as $emailingsTarget) {
            $bridgeContent->contentInsert('emailings_targets', [
                'type' => 'node',
                'bundle' => 'emailings_targets',
                'title' => $emailingsTarget,
            ]);
        }

        $this->finishUp();
    }
}
