<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;

class AddServiceLevelFilter extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'service_offers',
            'characteristics',
            [
                'name' => 'characteristics',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => true,
                'required' => false,
                'weight' => 12,
                'title' => [
                    'fr' => 'Niveau de service',
                ],
                'filter_widget'       => 'checkboxesgroup',
                'filter_order'        => 1,
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 12,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['characteristics'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ]
        );
        $bridge->contentTypeCreateOrUpdateField(
            'service_offers',
            'branches',
            [
                'name' => 'branches',
                'filter_order'        => 2,
            ]
        );

        $bridgeContent = new BridgeContent();
        $titles = ['Essentiel', 'Optionnel'];

        foreach ($titles as $title) {
            $bridgeContent->contentInsert('characteristics', [
                'type' => 'node',
                'bundle' => 'characteristics',
                'title' => $title,
                'langcode' => config('app.locale'),
            ]);
        }
    }

    public function down(): void
    {
    }
}
