<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateYoungstersFieldConfig extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'service_offers',
            'youngsters',
            [
                'name' => 'youngsters',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => true,
                'required' => false,
                'weight' => 12,
                'title' => [
                    'fr' => 'Type d\'individu',
                ],
                'filter_widget'       => 'checkboxesgroup',
                'filter_order'        => 7,
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 12,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['youngsters'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            12
        );
    }

    public function down(): void
    {
    }
}
