<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateServiceOffersFields extends Migration
{
    public function up(): void
    {
        $fields = ['staff_sizes', 'branches', 'regions', 'offer_structures', 'offer_themes'];

        $bridge = new BridgeContentType();

        foreach ($fields as $field) {
            $bridge->updateFieldOptions('service_offers', $field, [
                'required' => false
            ]);
        }

        $bridge->updateFieldOptions('service_offers', 'users', [
            'required' => true
        ]);
    }

    public function down(): void
    {
    }
}
